//
// Fragment shader for Picasso effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform vec4 modulateColor;
uniform vec4 textureRect;
uniform float time;

varying vec2 gUV;

//saturation variables
const vec3 lumCoeff = vec3 (0.2125, 0.7154, 0.0721);

//darkness
vec3 AvgLuminance = vec3(0.5, 0.5, 0.5);//assumption
float darknessFactor;

vec3 RGBtoHSV( float r, float g, float b );
vec3 HSVtoRGB( float h, float s, float v );

bool InBound(float x, float a, float b)
{
    return (x > a && x<=b);
}
void main(void)
{
     if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        float tt = float(time); //convert to seconds
        
        float texWidth = textureRect.z;
        float texHeight = textureRect.w;
        
        float textureWidth = texWidth;
        float textureHeight = texHeight; 

        vec4 part = texture2DRect( texUnit, gUV );
       
        float ratio1 = time;//time;//max(0.65,sin(tt)) ;//max(0.65, sin(tt));//0.79;//*;
        float ratio2 = 1.18-ratio1;// 0.39;
        float ratio3 = 1.48-ratio1;//0.69;
        float ratio4 = 0.99 - ratio1;//0.2;
        float ratio5 = 1.0-ratio1; //0.21;
        float ratio6 = 1.2-ratio1;//0.41;
        float ratio7 = 1.22-ratio1;//0.43;
        float ratio8 = 1.37-ratio1;//0.58;
        float ratio9 = 1.46-ratio1;//0.67;
        float ratio10 =1.3-ratio1;// 0.51;
        float ratio11 =1.45-ratio1;// 0.66;
        float ratio12 =1.04-ratio1;// 0.25;
        float ratio13 =1.08-ratio1;// 0.29;


        if( InBound(gUV.x, textureRect.x, textureRect.x+ratio1*texWidth) && InBound( gUV.y, textureRect.y+ratio1*texHeight,textureRect.y+texHeight))
        {
            float x = textureRect.x+texWidth-gUV.x;
            float y = textureRect.y+texHeight-gUV.y+texHeight/4.0;
            x = InBound(x, textureRect.x, textureRect.x+texWidth)?x:gUV.x;
            y = InBound(y, textureRect.y, textureRect.y+texHeight)?y:textureRect.y+texHeight-gUV.y;

            part = texture2DRect( texUnit, vec2(x, y) );
            
            int div = 120;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*1.2; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*.2; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
        }
        else if( InBound(gUV.x,textureRect.x+ratio1*texWidth, textureRect.x+texWidth) && InBound( gUV.y, textureRect.y+ratio2*texHeight,textureRect.y+texHeight))
        {
            float x = (gUV.x-textureRect.x)-texWidth/4.0+textureRect.x;
            float y = textureRect.y+texHeight-gUV.y+texHeight/3.0 ;
            
            x = InBound(x, textureRect.x, textureRect.x+texWidth)?x:textureRect.x+texWidth-gUV.x;
            y = InBound(y, textureRect.y, textureRect.y+texHeight)?y:textureRect.y+texHeight-gUV.y;

            vec4 sum = texture2DRect( texUnit, vec2( x,y ) );
            //Posterize
            int div = 50;
            float mul = float(div);
            sum.r = float( int( sum.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            sum.g = float( int( sum.g*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            sum.b = float( int( sum.b*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
            
            part = sum;
            
        }
        else if( InBound(gUV.x,textureRect.x+ratio3*texWidth, textureRect.x+texWidth) && InBound( gUV.y,textureRect.y, textureRect.y+ratio2*texHeight))
        {
            float x = 2.0 * ((gUV.x-textureRect.x)*1.4-2.0*texWidth/3.0) / texWidth - 1.0 ;//1.5
            float y = 2.0 * (texHeight-(gUV.y-textureRect.y)*1.1-texHeight/4.0) / texHeight - 1.0 ;//1.1
            
            //warped in the middle
            //        x = sign( x ) * x * x;
            //        y = sign( y ) * y * y ;
            
            float i = (x + 1.0 )*texWidth*.5+textureRect.x ;
            float j = (y + 1.0 )*texHeight*.5+textureRect.y;
            i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
            j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;
           
             part = texture2DRect( texUnit, vec2(i,j) );//vec2( TexCoord.x*1.5-2.0*texWidth/3.0, texHeight-TexCoord.y*1.1-texHeight/4.0) );

            int div = 60;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
        }
        else if( InBound(gUV.x,textureRect.x+ratio4*texWidth, textureRect.x+ratio3*texWidth) && InBound( gUV.y,textureRect.y, textureRect.y+ratio5*texHeight))
        {
            float x = 2.0 * (texWidth/3.0+(gUV.x-textureRect.x)*.6) / texWidth - 1.0 ;
            float y = 2.0 * ((gUV.y-textureRect.y)*.6 + texHeight/3.0) / texHeight - 1.0 ;
            
            //        x = 2.0 * asin(x) / 3.1415926;
            //        y = 2.0 * asin(y) / 3.1415926;
            
            float i = (x + 1.0 )*texWidth*.5+textureRect.x;
            float j = (y + 1.0 )*texHeight*.5+textureRect.y;
            i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
            j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;

            part = texture2DRect( texUnit, vec2(i,j) );//vec2( TexCoord.x*1.5-2.0*texWidth/3.0, texHeight-TexCoord.y*1.1-texHeight/4.0) );
            
            
            int div = 40;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*.7; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
        }
        else if( InBound(gUV.x, textureRect.x, textureRect.x+ratio4*texWidth) && InBound( gUV.y,textureRect.y, textureRect.y+ratio6*texHeight))
        {
            float x = 2.0 * (texWidth/2.0-(gUV.x-textureRect.x)*.8) / texWidth - 1.0 ;
            float y = 2.0 * ((gUV.y-textureRect.y)*.8+ texHeight/4.0) / texHeight - 1.0 ;
            
            //		float r = sqrt(x*x + y*y);
            //        float phi = atan(y,x);//equivalent to atan2
            //
            //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
            //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
            //        r = pow( r, fac );//fac );//magnifier
            //
            //		x = r * cos( phi );
            //        y = r * sin( phi );
            
            float i = (x + 1.0 )*texWidth*.5+textureRect.x;
            float j = (y + 1.0 )*texHeight*.5+textureRect.y;
            
            i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
            j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;

            part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
            
            int div = 60;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*1.4; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            
        }
        else if( InBound(gUV.x, textureRect.x+ratio4*texWidth, textureRect.x+ratio7*texWidth) && InBound( gUV.y,textureRect.y+ratio5*texHeight, textureRect.y+ratio6*texHeight))
        {
            
            float x = 2.0 * (gUV.x*1.4-textureRect.x*1.4) / texWidth - 1.0 ;
            float y = 2.0 * (gUV.y*1.4-textureRect.y*1.4) / texHeight - 1.0 ;
            
            //		float r = sqrt(x*x + y*y);
            //        float phi = atan(y,x);//equivalent to atan2
            //
            //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
            //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
            //        r = pow( r, fac );//fac );//magnifier
            //
            //		x = r * cos( phi );
            //        y = r * sin( phi );
            
            float i = (x + 1.0 )*texWidth*.5+textureRect.x;
            float j = (y + 1.0 )*texHeight*.5+textureRect.y;
            
            i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
            j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;

            part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
            
            int div = 80;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*1.6; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*.4; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*.5; //+ float(div)/360.0 ;
            
        }
        else if( InBound(gUV.x, textureRect.x+ratio7*texWidth, textureRect.x+ratio8*texWidth) && InBound( gUV.y,textureRect.y+ratio5*texHeight, textureRect.y+ratio6*texHeight))
        {
            
            float x = 2.0 * (gUV.x*1.0-textureRect.x*1.0) / texWidth - 1.0 ;
            float y = 2.0 * (gUV.y*1.0-textureRect.y*1.0) / texHeight - 1.0 ;
            
            //		float r = sqrt(x*x + y*y);
            //        float phi = atan(y,x);//equivalent to atan2
            //
            //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
            //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
            //        r = pow( r, fac );//fac );//magnifier
            //
            //		x = r * cos( phi );
            //        y = r * sin( phi );
            
            float i = (x + 1.0 )*texWidth*.5+textureRect.x;
            float j = (y + 1.0 )*texHeight*.5+textureRect.y;
            
            i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
            j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;

            part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
            
            int div = 110;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*.9; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*1.4; //+ float(div)/360.0 ;
            
        }
        else if( InBound(gUV.x, textureRect.x+ratio8*texWidth, textureRect.x+ratio3*texWidth) && InBound( gUV.y,textureRect.y+ratio5*texHeight, textureRect.y+ratio6*texHeight))
        {
            
            float x = 2.0 * (gUV.x-textureRect.x) / texWidth - 1.0 ;
            float y = 2.0 * (gUV.y-textureRect.y) / texHeight - 1.0 ;
            
            //		float r = sqrt(x*x + y*y);
            //        float phi = atan(y,x);//equivalent to atan2
            //
            //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
            //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
            //        r = pow( r, fac );//fac );//magnifier
            //
            //		x = r * cos( phi );
            //        y = r * sin( phi );
            
            float i = (x + 1.0 )*texWidth*.5+textureRect.x;
            float j = (y + 1.0 )*texHeight*.5+textureRect.y;
            
            i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
            j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;

            part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
            
            int div = 65;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.1; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*1.6; //+ float(div)/360.0 ;
            
        }
        else if( InBound(gUV.x, textureRect.x+ratio8*texWidth, textureRect.x+ratio3*texWidth) && InBound( gUV.y,textureRect.y+ratio6*texHeight, textureRect.y+ratio9*texHeight))
        {
            
            float x = 2.0 * (gUV.x-textureRect.x) / texWidth - 1.0 ;
            float y = 2.0 * (gUV.y-textureRect.y) / texHeight - 1.0 ;
            
            //		float r = sqrt(x*x + y*y);
            //        float phi = atan(y,x);//equivalent to atan2
            //
            //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
            //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
            //        r = pow( r, fac );//fac );//magnifier
            //
            //		x = r * cos( phi );
            //        y = r * sin( phi );
            
            float i = (x + 1.0 )*texWidth*.5+textureRect.x;
            float j = (y + 1.0 )*texHeight*.5+textureRect.y;
            i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
            j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;

            part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
            
            int div = 50;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*.9; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*.9; //+ float(div)/360.0 ;
        
        }
        else if( InBound(gUV.x, textureRect.x+ratio10*texWidth, textureRect.x+ratio8*texWidth) && InBound( gUV.y,textureRect.y+ratio6*texHeight, textureRect.y+ratio1*texHeight))
        {
            
            float x = 2.0 * (gUV.x*1.01-textureRect.x*1.01)/texWidth - 1.0 ;
            float y = 2.0 * (gUV.y*1.01-textureRect.y*1.01)/texHeight - 1.0 ;
            
            //		float r = sqrt(x*x + y*y);
            //        float phi = atan(y,x);//equivalent to atan2
            //
            //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
            //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
            //        r = pow( r, fac );//fac );//magnifier
            //
            //		x = r * cos( phi );
            //        y = r * sin( phi );
            
            float i = (x + 1.0 )*texWidth*.5+textureRect.x;
            float j = (y + 1.0 )*texHeight*.5+textureRect.y;
            i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
            j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;

            part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
            
            int div = 45;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*1.2; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*.9; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*1.1; //+ float(div)/360.0 ;
            
        }
        else if( InBound(gUV.x, textureRect.x+ratio5*texWidth, textureRect.x+ratio10*texWidth) && InBound( gUV.y,textureRect.y+ratio11*texHeight, textureRect.y+ratio1*texHeight))
        {
            
            float x = 2.0 * (gUV.x*1.03-textureRect.x*1.03) / texWidth - 1.0 ;
            float y = 2.0 * (gUV.y*1.03-textureRect.y*1.03) / texHeight - 1.0 ;
            
            //		float r = sqrt(x*x + y*y);
            //        float phi = atan(y,x);//equivalent to atan2
            //
            //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
            //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
            //        r = pow( r, fac );//fac );//magnifier
            //
            //		x = r * cos( phi );
            //        y = r * sin( phi );
            
            float i = (x + 1.0 )*texWidth*.5+textureRect.x;
            float j = (y + 1.0 )*texHeight*.5+textureRect.y;
            i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
            j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;

            part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
            
            int div = 67;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;

            
        }
         else if( InBound(gUV.x, textureRect.x+ratio8*texWidth, textureRect.x+ratio1*texWidth) && InBound( gUV.y,textureRect.y+ratio11*texHeight, textureRect.y+ratio1*texHeight))
        {
            
            float x = 2.0 * (gUV.x*.98-textureRect.x*0.98) / texWidth - 1.0 ;
            float y = 2.0 * (gUV.y*.98-textureRect.y*0.98) / texHeight - 1.0 ;
            
            //		float r = sqrt(x*x + y*y);
            //        float phi = atan(y,x);//equivalent to atan2
            //
            //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
            //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
            //        r = pow( r, fac );//fac );//magnifier
            //
            //		x = r * cos( phi );
            //        y = r * sin( phi );
            
            float i = (x + 1.0 )*texWidth*.5+textureRect.x;
            float j = (y + 1.0 )*texHeight*.5+textureRect.y;
            i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
            j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;

            part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
            
            int div = 40;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*1.1; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
        
        }
         else if( InBound(gUV.x, textureRect.x+ratio4*texWidth, textureRect.x+ratio10*texWidth) && InBound( gUV.y,textureRect.y+ratio6*texHeight, textureRect.y+ratio11*texHeight))
        {
            
            float x = 2.0 * (gUV.x*1.1-textureRect.x*1.1) / texWidth - 1.0 ;
            float y = 2.0 * (gUV.y*1.1-textureRect.y*1.1) / texHeight - 1.0 ;
            
            //		float r = sqrt(x*x + y*y);
            //        float phi = atan(y,x);//equivalent to atan2
            //
            //        float t = 3.1415/4.0;//mod( float( timer ), 30000.0 ) / 1000.0; //0 - 30 seconds
            //        float fac = abs( sin( t ) )*2.0 + .125;//+1.5;/// 2.0 + 1.5;
            //        r = pow( r, fac );//fac );//magnifier
            //
            //		x = r * cos( phi );
            //        y = r * sin( phi );
            
            float i = (x + 1.0 )*texWidth*.5+textureRect.x;
            float j = (y + 1.0 )*texHeight*.5+textureRect.y;
            i  = InBound(i, textureRect.x, textureRect.x+texWidth)?i:gUV.x;
            j = InBound(j, textureRect.y, textureRect.y+texHeight)?j:gUV.y;

            part = texture2DRect( texUnit, vec2(i,j) ); //texture2DRect( whichTexture, vec2( texWidth/2.0-TexCoord.x*.8, TexCoord.y*.8+ texHeight/4.0) );
            
            int div = 50;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.1; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*1.9; //+ float(div)/360.0 ;
        
        }
        else if( InBound(gUV.x, textureRect.x, textureRect.x+ratio12*texWidth) && InBound( gUV.y,textureRect.y+ratio6*texHeight, textureRect.y+ratio11*texHeight))
        {
            float x = textureRect.y+textureHeight-gUV.y;
            float y = textureWidth/2.0-(gUV.x-textureRect.x) +textureRect.x ;
            
            x = InBound(x, textureRect.x, textureRect.x+texWidth)?x:gUV.x  ;
            y = InBound(y, textureRect.y, textureRect.y+texHeight)?y:gUV.y;
            
            part =  texture2DRect( texUnit, vec2( x,y));
            
            int div = 60;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            
        }
        else if( InBound(gUV.x, textureRect.x, textureRect.x+ratio13*texWidth) && InBound( gUV.y,textureRect.y+ratio11*texHeight, textureRect.y+ratio1*texHeight))
        {
            float x = textureWidth/2.0-(gUV.x-textureRect.x)+textureRect.x;
            float y = textureHeight/2.0-(textureHeight+textureRect.y-gUV.y)+textureRect.y;
            x = InBound(x, textureRect.x, textureRect.x+texWidth)?x:gUV.x;
            y = InBound(y, textureRect.y, textureRect.y+texHeight)?y:gUV.y;
            
            part =  texture2DRect( texUnit, vec2( x , y) );
            
            int div = 90;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.5; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0; //+ float(div)/360.0 ;
        
        }
        else
        {
            float x = (gUV.x-textureRect.x)*1.03+textureRect.x;
            float y = (gUV.y-textureRect.y)*1.03+textureRect.y;
            x = InBound(x, textureRect.x, textureRect.x+texWidth)?x:gUV.x;
            y = InBound(y, textureRect.y, textureRect.y+texHeight)?y:gUV.y;
            part = texture2DRect( texUnit, vec2( x,y) );
            
            int div = 40;
            float mul = float(div);
            part.r = float( int( part.r*360.0 ) / div )*mul / 360.0*.7; //+ float(div)/360.0 ;
            part.g = float( int( part.g*360.0 ) / div )*mul / 360.0*1.8; //+ float(div)/360.0 ;
            part.b = float( int( part.b*360.0 ) / div )*mul / 360.0*1.3; //+ float(div)/360.0 ;
        }
        
        gl_FragColor = modulateColor*part;
    }
}

vec3 RGBtoHSV( float r, float g, float b )
{
    float h, s, v;
    
    float theMin, theMax, delta;
    theMin = min( r, min(g, b) );
    theMax = max( r, max(g, b) );
    v = theMax;				// v
    delta = theMax - theMin;
    
    if( theMax != 0.0 )
        s = delta / theMax;		// s
    else {
        // r = g = b = 0		// s = 0, v is undefined
        s = 0.0;
        h = -1.0;
        return vec3(h, s, v);
    }
    
    if( r == theMax )
        h = ( g - b ) / delta;		// between yellow & magenta
    else if( g == theMax )
        h = 2.0 + ( b - r ) / delta;	// between cyan & yellow
    else
        h = 4.0 + ( r - g ) / delta;	// between magenta & cyan
    h *= 60.0;				// degrees
    if( h < 0.0 )
        h += 360.0;
    
    vec3 hsv = vec3( h, s, v );
    return hsv;
}

vec3 HSVtoRGB( float h, float s, float v )
{
    float r, g, b;
    
	float i;
	float f, p, q, t;
	if( s == 0.0 ) {
		// achromatic (grey)
		r = g = b = v;
		return vec3( r, g, b);
	}
	h /= 60.0;			// sector 0 to 5
	i = floor( h );
	f = h - float(i);			// factorial part of h
	p = v * ( 1.0 - s );
	q = v * ( 1.0 - s * f );
	t = v * ( 1.0 - s * ( 1.0 - f ) );
	if( i == 0.0 )
    {
        r = v;
        g = t;
        b = p;
	}
    else if( i == 1.0 )
    {
        r = q;
        g = v;
        b = p;
	}
    else if( i == 2.0 )
    {
        r = p;
        g = v;
        b = t;
    }
	else if( i == 3.0 )
    {
        r = p;
        g = q;
        b = v;
	}
	else if( i == 4.0 )
    {
        r = t;
        g = p;
        b = v;
    }
	else
    {
        r = v;
        g = p;
        b = q;
	}
    
    return vec3( r, g, b );
}